<?php
    /*
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */
?>
<h4 class="mb-4 title">SEO</h4>
<div class="well">
    In questa sezione è possibile modificare le impostazioni per ottimizzare il sito dal punto di
    vista SEO, gestire le mappe del stio e modificare il file robot.txt. Per maggiori informazioni 
    consultare il manuale di Geecom.
</div>

<form class="form-horizontal" role="form" name="formSeo" action="../controller/controllerImpostazioni.php" method="post" enctype="multipart/form-data">
    <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniSEO">

    <div class="form-row mt-5">
        <div class="form-group col-lg-4">
            <label for="select1" class="d-block" >Consenti indicizzazione</label> 
            <input type="checkbox" name="consentiIndicizzazione" class="js-switch" value="si" <?php if($impostazioni["consentiIndicizzazione"]=="si") echo"checked"; ?> />
        </div>
        
        <div class="form-group col-lg-4">
            <label for="select1" class="d-block" >Ottimizzazione URL</label> 
            <input type="checkbox" name="ottimizzazioneUrl" class="js-switch" value="si" <?php if($impostazioni["ottimizzazioneUrl"]=="si") echo"checked"; ?> />
        </div>
        
        <div class="form-group col-lg-4">
            <label for="select1" class="d-block" >Attiva cache</label> 
            <input type="checkbox" name="attivaCache" class="js-switch" value="si" <?php if($impostazioni["attivaCache"]=="si") echo"checked"; ?> />
        </div>
    </div>

    <div class="row mt-5">
        <div class="col-12">
            <h5>Mappa del sito</h5>
            <hr>
        </div>
            
        <div class="form-group col-lg-4">
                <label for="metadescription">Generazione mappa sito</label>
                <select name="generazioneMappa" class="form-control">
                <?php 
                    $datiComponenteEcommerce = $geecomDb->leggiSingolaRiga("geecB_componenti","Ecommerce","nome");
                    if(isset($datiComponenteEcommerce["versione"])) { // se esiste il componente ecommerce viene cambiato l'ultimo elemento perché bisogna includere anche i prodotti
                        $opzioniSitemap = ["Non generare","Genera singola mappa con tutti i contenuti","Genera mappa separata per pagine, articoli e prodotti"];
                    }
                    else {
                        $opzioniSitemap = ["Non generare","Genera singola mappa con tutti i contenuti","Genera mappa separata per pagine e articoli"];
                    }
                    
                    foreach($opzioniSitemap as $opzione) {
                        $selezionato = ($impostazioni["generazioneMappa"]==$opzione) ? "selected" : "";
                        ?><option value="<?= $opzione ?>" <?= $selezionato ?>><?= $opzione ?></option><?php
                    }
                ?>
                </select>
                <small class="text-muted">Scegli come generare le mappe del tuo sito per i motori di ricerca</small>
        </div>
        
        <div class="form-group col-lg-4">
            <label for="select1" class="d-block" >Genera mappe separate per lingua</label> 
            <input type="checkbox" name="generaMappeSeparatePerLingua" class="js-switch" value="si" <?php if($impostazioni["generaMappeSeparatePerLingua"]=="si") echo"checked"; ?> />
            <small class="d-block text-muted">Se attivo vengono generate mappe diverse per ogni lingua</small>
        </div>
    </div>
    
    <?php 
        if($impostazioni["generazioneMappa"]!="Non generare") {
            $arrayMappe = [];

            if($impostazioni["generazioneMappa"]=="Genera singola mappa con tutti i contenuti" && $impostazioni["generaMappeSeparatePerLingua"]=="si") {
                foreach($lingue as $lingua) {
                    $linguaLetteraMaiuscola = ucfirst($lingua);
                    if($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"]=="si") {
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-pagine-".substr($lingua,0,2).".xml");
                    }
                }
            }
            else if($impostazioni["generazioneMappa"]=="Genera singola mappa con tutti i contenuti") {
                array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-sito.xml");
            }
            if($impostazioni["generazioneMappa"]=="Genera mappa separata per pagine e articoli" && $impostazioni["generaMappeSeparatePerLingua"]=="si") {
                foreach($lingue as $lingua) {
                    $linguaLetteraMaiuscola = ucfirst($lingua);
                    if($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"]=="si") {
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-pagine-". substr($lingua,0,2).".xml");
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-articoli-".substr($lingua,0,2).".xml");
                    }
                }
            }
            else if($impostazioni["generazioneMappa"]=="Genera mappa separata per pagine e articoli") {
                array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-pagine.xml");
                array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-articoli.xml");
            }
    ?>
            <div class="card">
                <div class="card-header">
                    <div class="card-title mb-0">Mappe del sito</div>
                </div>
                <div class="card-body">
                    <?php 
                        if(count($arrayMappe)>1) {
                            $indiceMappe = $impostazioni["urlSito"]."/indice-mappe.xml";
                            ?><a href="<?= $indiceMappe ?>"><?= $indiceMappe ?></a><br><?php
                        }
                        foreach($arrayMappe as $mappa) {
                            ?><a href="<?= $mappa ?>"><?= $mappa ?></a><br><?php
                        }
                    ?>
                </div>
                <div class="card-footer text-right">
                     <span class="mr-2 text-muted">Ultimo aggiornamento: <?= date("d/m/Y H:i",strtotime($statisticheGeecom["ultimoAggiornamentoSitemap"])) ?></span>
                    <a class="btn btn-primary" href="javascript:void" onclick="eseguiAggiornamentoMappeSito()"><i class="fas fa-redo" id="iconaPulsanteAggiornamentoMappe" ></i> Aggiorna mappe del sito</a>
                </div>
            </div>
    <?php
        }
    ?>

    <div class="row mt-5">
        <div class="col-12">
            <h5> Contenuto file robot.txt </h5>
            <textarea class="form-control" rows="8" id="testoArticolo" name="contenutoFileRobots" placeholder="Edita il file robots.txt"><?php echo file_get_contents('../robots.txt', true); ?></textarea>
        </div>
    </div>	  

    <div class="footer">
        <button type="button" class="btn btn-primary float-right" onclick="document.formSeo.submit()"><i class="fas fa-check"></i> Salva tutto</button>
    </div>
</form>